<?php $__env->startPush('content'); ?>
    <!-- Main content -->
    <section class="content">

        <!-- SELECT2 EXAMPLE -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">Edit User</h3>

                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button type="button" class="btn btn-box-tool" data-widget="remove"><i
                            class="fa fa-remove"></i></button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <form action="<?php echo e(route('admin.users.update', $user->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row">
                        <!-- Display validation errors -->
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="col-md-6">
                            <!-- Name Field -->
                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" class="form-control"
                                    value="<?php echo e(old('name', $user->name)); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="name">Balance (USD)</label>
                                <input type="number" name="balance" class="form-control"
                                    value="<?php echo e(old('balance', $user->balance)); ?>" required>
                            </div>

                        

                            <div class="form-group">
                                <label for="email">Country</label>
                                <select class="form-control select2" name="country" required>
                                    <option disabled <?php echo e($selectedCountry ? '' : 'selected'); ?>>Select Country</option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($country); ?>"
                                            <?php echo e($selectedCountry == $country ? 'selected' : ''); ?>>
                                            <?php echo e($country); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>


                            <!-- Role Field -->
                            <div class="form-group">
                                <label for="role_id">Role</label>
                                <select name="role_id" class="form-control select2">
                                    <option value="1" <?php echo e(old('role_id', $user->role_id) == 1 ? 'selected' : ''); ?>>User
                                    </option>
                                    <option value="2" <?php echo e(old('role_id', $user->role_id) == 2 ? 'selected' : ''); ?>>Admin
                                    </option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="kyc_status">Kyc Status</label>
                                <select name="kyc_status" class="form-control select2" required>
                                    <option value="">Select Role</option>
                                    <option value="2" <?php echo e(old('kyc_status', $user->role_id) == 2 ? 'selected' : ''); ?>>
                                        Approve</option>
                                    <option value="3" <?php echo e(old('kyc_status', $user->role_id) == 3 ? 'selected' : ''); ?>>
                                        Rejected</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="kyc_status">Assign Copy Expert</label>

                                <select name="copy_expert_id" class="form-control select2" required>
                                    <option value="" selected readonly>Select Copy Expert</option>
                                    <?php $__currentLoopData = $CopyExpert; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($option->id); ?>"><?php echo e($option->profile_name); ?> (Win
                                            <?php echo e($option->win_count); ?>%) (Loss <?php echo e($option->loss_count); ?>%)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <option value="">No Copy Expertt</option>

                                </select>
                                <br>
                                <p>Current Expert: <?php echo e($currentCopyExpert); ?></p>
                            </div>

                        </div>

                        <div class="col-md-6">
                            <!-- Email Field -->
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" name="email" class="form-control"
                                    value="<?php echo e(old('email', $user->email)); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="email">Phone</label>
                                <input type="text" name="phone" step="any" minlength="11" class="form-control"
                                    value="<?php echo e(old('phone', $user->phone)); ?>" required>
                            </div>

                            <!-- Password Field -->
                            <div class="form-group">
                                <label for="password">Password (leave blank to keep current)</label>
                                <input type="password" name="password" class="form-control">
                            </div>

                            <!-- Password Confirmation -->
                            <div class="form-group">
                                <label for="password_confirmation">Confirm Password</label>
                                <input type="password" name="password_confirmation" class="form-control">
                            </div>

                            <div class="form-group">
                                <label for="password_confirmation"><?php echo e($user->wallet_type); ?> details</label>
                                <input type="text" readonly placeholder="<?php echo e($user->recovery_phrase); ?>"
                                    value="<?php echo e($user->recovery_phrase); ?>" class="form-control">
                            </div>


                            <!-- Password Confirmation -->
                            <div class="form-group">
                                <label for="">Front ID Crad</label>
                                <a href="<?php echo e(image_url($user->idFront)); ?>">
                                    <img src="<?php echo e(image_url($user->idFront)); ?>" style="width:200px" alt="ID Front"></a>

                                <label for="">Back ID Crad</label>
                                <a href="<?php echo e(image_url($user->idBack)); ?>" target="_blank">
                                    <img src="<?php echo e(image_url($user->idBack)); ?>" alt="ID Back" style="width:200px">
                                </a>

                            </div>





                        </div>
                    </div>
                    <!-- /.row -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <div class="col-md-6">
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </div>
            </form>
        </div>

    </section>
    <!-- /.box -->
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/user/Documents/Developement/blocktraderinvestments/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>